/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.idm.trident;

import com.filenet.wcm.api.ContainableObject;
import com.filenet.wcm.api.Document;
import com.filenet.wcm.api.Folder;
import com.filenet.wcm.api.Folders;
import com.filenet.wcm.api.Properties;
import com.filenet.wcm.api.Property;
import com.filenet.wcm.api.Session;
import com.filenet.wcm.api.TransportInputStream;
import com.filenet.wcm.api.VersionSeries;
import com.filenet.wcm.toolkit.client.ui.WcmDlg;
import com.filenet.wcm.toolkit.client.ui.WcmDlgFactory;
import com.filenet.wcm.toolkit.client.ui.WcmDlgItem;
import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import filenet.vw.base.logging.VWTimerLog;
import filenet.vw.idm.toolkit.IVWIDMDocClass;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.IVWIDMFolder;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.toolkit.IVWIDMLink;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.idm.trident.VWIDMTridentFolder;
import filenet.vw.idm.trident.VWIDMTridentItem;
import filenet.vw.idm.trident.VWIDMTridentLibrary;
import filenet.vw.idm.trident.VWTridentFactory;
import filenet.vw.idm.trident.VWTridentFactoryProperties;
import java.awt.Container;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Iterator;

public final class VWIDMTridentDocument
extends VWIDMTridentItem
implements IVWIDMDocument {
    private static final String m_className = "VWIDMTridentDocument";
    VersionSeries m_versionSeries = null;
    boolean m_useCurrentVersion = false;
    boolean m_useReleasedVersion = false;
    boolean m_isExternalReference = false;
    String m_mimeType = null;
    String m_fileName = null;
    private String[] m_currentUser = null;

    private void getProps() {
        String m_method = "getProps:";
        try {
            if (this.m_versionSeries == null) {
                this.m_versionSeries = (VersionSeries)this.getProp("VersionSeries");
            }
            this.m_currentUser = ((VWTridentFactoryProperties)VWIDMBaseFactory.instance().getProperties()).getCurrentUser();
            try {
                this.m_fileName = ((Document)this.m_wcmObject).getFilename();
            }
            catch (Exception e) {
                this.m_fileName = "CEDOC";
            }
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "Current User =" + Logger.asString(this.m_currentUser) + ", VersionSeries =" + this.m_versionSeries.getId() + ", libId=" + this.m_lib.getId());
            }
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method + this.getId(), e);
        }
    }

    protected VWIDMTridentDocument(Document doc, VWIDMTridentLibrary lib) {
        String m_method = "CTOR 1";
        if (doc == null) {
            logger.warning(m_className, m_method, "No WcmObject 1!");
            return;
        }
        this.m_wcmObject = doc;
        this.m_lib = lib;
        this.m_labelPropName = this.m_lib.getDocumentNameProperty();
        this.getProps();
    }

    protected VWIDMTridentDocument(Document doc, VWIDMTridentLibrary lib, WcmDlgItem dlgItem) throws VWException {
        String m_method = "CTOR 2 (from dialog)";
        if (doc == null) {
            logger.warning(m_className, m_method, "No WcmObject 2!");
            return;
        }
        this.m_lib = lib;
        this.m_dlgItem = dlgItem;
        this.m_labelPropName = this.m_lib.getDocumentNameProperty();
        this.m_wcmObject = doc;
        this.getProps();
        if (this.m_versionSeries == null) {
            throw new VWException("idm.trident.IDMTridentDocument.noVersionSeries", "No Version Series object is available.");
        }
        int versionChoice = 3;
        if (dlgItem != null) {
            versionChoice = dlgItem.getVersionChoice();
        }
        switch (versionChoice) {
            case 2: {
                this.m_useCurrentVersion = true;
                this.m_wcmObject = this.m_versionSeries.getCurrentVersion();
                if (this.m_wcmObject == null) break;
                logger.info(m_className, m_method, "Using current version. id=" + this.m_wcmObject.getId());
                break;
            }
            case 1: {
                this.m_wcmObject = this.m_versionSeries.getReleasedVersion();
                if (this.m_wcmObject == null) {
                    logger.warning(m_className, m_method, "This document does not have released version.., use current..");
                    this.m_useCurrentVersion = true;
                    this.m_wcmObject = this.m_versionSeries.getCurrentVersion();
                    logger.info(m_className, m_method, "Using current version. id=" + this.m_wcmObject.getId());
                    break;
                }
                this.m_useReleasedVersion = true;
                logger.info(m_className, m_method, "Using released version.id=" + this.m_wcmObject.getId());
            }
        }
        if (this.m_wcmObject == null) {
            throw new VWException("idm.trident.NoWcmObject", "Unable to retrieve the WcmObject.");
        }
    }

    public String getVersionSeriesId() {
        if (this.m_versionSeries != null) {
            return this.m_versionSeries.getId();
        }
        return null;
    }

    public String getVersionId() {
        if (this.m_useCurrentVersion) {
            return null;
        }
        if (this.m_useReleasedVersion) {
            return "-1";
        }
        return this.getId();
    }

    protected VWIDMTridentDocument(VersionSeries versionSeries, Document doc, VWIDMTridentLibrary lib, boolean wantCurrent, boolean wantReleased) {
        String m_method = "CTOR 3, with VersionSeries";
        if (versionSeries == null) {
            logger.warning(m_className, m_method, "No WcmObject for VersionSeries!!");
            return;
        }
        this.m_versionSeries = versionSeries;
        if (wantCurrent) {
            doc = this.m_versionSeries.getCurrentVersion();
            this.m_useCurrentVersion = true;
        } else if (wantReleased) {
            doc = this.m_versionSeries.getReleasedVersion();
            this.m_useReleasedVersion = true;
        }
        if (doc == null) {
            logger.warning(m_className, m_method, "No document available!");
        }
        this.m_wcmObject = doc;
        this.m_lib = lib;
        this.m_labelPropName = this.m_lib.getDocumentNameProperty();
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, this.getId() + ", useCurrentVersion=" + new Boolean(this.m_useCurrentVersion).toString() + ", useReleasedVersion=" + new Boolean(this.m_useReleasedVersion).toString());
        }
        this.getProps();
    }

    public String getLibraryId() {
        return this.m_lib.getId();
    }

    public String getLibraryLabel() {
        return this.m_lib.getLabel();
    }

    public String getCanonicalName() {
        String m_method = "getCanonicalName";
        String id = this.m_versionSeries != null ? this.m_versionSeries.getId() : "";
        String version = this.getId();
        if (this.m_useCurrentVersion) {
            version = "";
        } else if (this.m_useReleasedVersion) {
            version = "-1";
        }
        String res = Integer.toString(3) + ":" + this.m_lib.toString() + ":" + id + ":" + version;
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, "returns=" + res);
        }
        return res;
    }

    public VWAttachment getVWAttachment() throws VWException {
        String m_method = "getVWAttachment";
        VWAttachment ret = new VWAttachment();
        ret.setType(this.getType());
        ret.setLibraryType(this.getLibraryType());
        ret.setLibraryName(this.getLibraryLabel());
        ret.setId(this.m_versionSeries != null ? this.m_versionSeries.getId() : null);
        ret.setVersion(this.getVersionId());
        ret.setAttachmentName(this.getLabel());
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, "returns " + ret.toString());
        }
        return ret;
    }

    public IVWIDMItem[] list(boolean dirOnly) throws VWException {
        return null;
    }

    public Object getProp(String propName) throws VWException {
        return VWIDMTridentDocument.getProp((Document)this.m_wcmObject, propName);
    }

    public void save() throws VWException {
        String m_method = "save:" + this.getId();
        Properties propsToSave = this.getSaveProperties();
        if (propsToSave != null) {
            try {
                ((Document)this.m_wcmObject).setProperties(propsToSave);
                this.m_props.clear();
            }
            catch (Exception e) {
                logger.throwing(m_className, m_method, e);
            }
        }
    }

    public int getType() {
        return 3;
    }

    public String getVersionNumber() {
        try {
            String versionNumber = this.getProp("MajorVersionNumber").toString() + "." + this.getProp("MinorVersionNumber").toString();
            return versionNumber;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public byte[] getContents() throws VWException {
        return this.getContents((Document)this.m_wcmObject, 1);
    }

    public byte[] getContents(boolean bCheckout) throws VWException {
        String m_method = "getContents:" + this.getId() + "bCheckout=" + new Boolean(bCheckout).toString();
        logger.entering(m_className, m_method);
        try {
            Document theDoc = null;
            if (bCheckout) {
                if (this.canCheckout()) {
                    this.m_versionSeries.checkout();
                }
                try {
                    theDoc = ((Document)this.m_wcmObject).getReservation();
                    TransportInputStream in = theDoc.getContent();
                    in.close();
                }
                catch (Exception e) {
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "IGNORABLE exception: " + e.getMessage());
                    }
                    theDoc = null;
                }
                this.refresh();
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "finished checkedout");
                }
            }
            if (theDoc == null) {
                theDoc = (Document)this.m_wcmObject;
            }
            byte[] byArray = this.getContents(theDoc, 1);
            Object var6_7 = null;
            logger.exiting(m_className, m_method);
            return byArray;
        }
        catch (VWException ve) {
            try {
                throw ve;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                logger.exiting(m_className, m_method);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean checkin(Frame parent, byte[] contents, boolean withUI, String fileName, String dlgTitle) throws VWException {
        boolean bl;
        TransportInputStream in;
        String m_method;
        block23: {
            Document reservationObj;
            block21: {
                boolean bl2;
                block22: {
                    block17: {
                        boolean bl3;
                        block20: {
                            block18: {
                                boolean bl4;
                                block19: {
                                    m_method = "checkin:" + this.getId();
                                    in = null;
                                    if (!withUI) break block17;
                                    if (logger.isFinest()) {
                                        logger.finest(m_className, m_method, "Lib=" + this.m_lib.getLabel() + ", libId=" + this.m_lib.getId() + ", for id=" + this.getId() + ", filename=" + (fileName == null ? "NONAME" : fileName));
                                    }
                                    Session sess = (Session)VWIDMBaseFactory.instance().getProperties().getProperty("Session");
                                    ((VWTridentFactory)VWIDMBaseFactory.instance()).getScope();
                                    WcmDlg dlg = WcmDlgFactory.getCheckinDialog((Frame)parent, (Session)sess, (String)this.m_lib.getId(), (String)this.getId(), (InputStream)new ByteArrayInputStream(contents), (long)(contents == null ? 0 : contents.length), (int)1);
                                    if (logger.isFinest()) {
                                        logger.finest(m_className, m_method, "got " + (dlg == null ? "" : "NON-") + "NULL WcmDlg from getCheckinDialog..");
                                    }
                                    dlg.setTitle(dlgTitle);
                                    dlg.setFilename(fileName);
                                    String mimeType = this.getMimeType();
                                    if (logger.isFinest()) {
                                        logger.finest(m_className, m_method, "Setting MIME type: " + mimeType);
                                    }
                                    dlg.setMimeType(mimeType);
                                    if (dlg.showDialog((Container)parent) != 0) break block18;
                                    this.refresh();
                                    bl4 = true;
                                    Object var13_16 = null;
                                    if (in == null) break block19;
                                    try {
                                        in.close();
                                    }
                                    catch (Exception ex) {
                                        // empty catch block
                                    }
                                }
                                return bl4;
                            }
                            bl3 = false;
                            Object var13_17 = null;
                            if (in == null) break block20;
                            try {
                                in.close();
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                        return bl3;
                    }
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "NOUI");
                    }
                    if ((reservationObj = ((Document)this.m_wcmObject).getReservation()) != null) break block21;
                    logger.warning(m_className, m_method, "No Reservation object?");
                    bl2 = false;
                    Object var13_18 = null;
                    if (in == null) break block22;
                    try {
                        in.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                return bl2;
            }
            in = new TransportInputStream((InputStream)new ByteArrayInputStream(contents));
            in.setMimeType(this.getMimeType());
            in.setFilename(fileName);
            reservationObj.setContent(in, true, false);
            in.close();
            in = null;
            this.refresh();
            bl = true;
            Object var13_19 = null;
            if (in == null) break block23;
            try {
                in.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return bl;
        catch (Exception e) {
            try {
                logger.throwing(m_className, m_method, e);
                throw new VWException("idm.trident.IDMTridentDocument.checkinWithUI", "{0}", e.getMessage());
            }
            catch (Throwable throwable) {
                block24: {
                    Object var13_20 = null;
                    if (in == null) break block24;
                    try {
                        in.close();
                    }
                    catch (Exception ex) {}
                }
                throw throwable;
            }
        }
    }

    public byte[] checkoutNoUI() throws VWException {
        return this.getContents(true);
    }

    public void cancelCheckoutNoUI() throws VWException {
        String m_method = "cancelCheckoutNoUI:" + this.getId();
        try {
            Document reservationObj = ((Document)this.m_wcmObject).getReservation();
            if (reservationObj == null) {
                logger.warning(m_className, m_method, "No reservation object?");
                return;
            }
            reservationObj.cancelCheckout();
            this.refresh();
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw new VWException("idm.trident.IDMTridentDocument.cancelCheckoutNoUI", "Failed to cancel checkout.  {0}", e.getMessage());
        }
    }

    public void markCheckout() throws VWException {
        String m_method = "markCheckout";
        try {
            this.m_versionSeries.checkout();
            this.refresh();
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw new VWException("idm.trident.IDMTridentDocument.markCheckout", "Failed to checkout document.  {0}", e.getMessage());
        }
    }

    public boolean isCheckedOut() {
        boolean res = this.isReserved();
        if (logger.isFinest()) {
            logger.finest(m_className, "isCheckedOut", this.getLabel() + " is " + (res ? "" : "not") + " checked out.");
        }
        return res;
    }

    public boolean canView() {
        return false;
    }

    public boolean canOpen() {
        String m_method = "canView";
        try {
            boolean res;
            int asMask = ((Document)this.m_wcmObject).getAccessMask();
            boolean bl = res = (asMask & 0x80) != 0;
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, this.m_currentUser[0] + " can" + (res ? "" : "not") + " view " + this.getLabel());
            }
            return res;
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            return false;
        }
    }

    public boolean canCheckout() {
        String m_method = "canCheckout";
        try {
            boolean res = !this.isExternalReference() && !this.isReserved() && this.isCurrentVersion();
            int asMask = ((Document)this.m_wcmObject).getAccessMask();
            boolean bl = res = res && (asMask & 0x80) != 0 && (asMask & 2) != 0 && (asMask & 4) != 0;
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, this.m_currentUser[0] + " can" + (res ? "" : "not") + " check out " + this.getLabel());
            }
            return res;
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            return false;
        }
    }

    private int getReservationSecurityMask() {
        String m_method = "getReservationSecurityMask";
        try {
            if (this.isReserved()) {
                Document reservationObj = ((Document)this.m_wcmObject).getReservation();
                if (reservationObj == null) {
                    logger.warning(m_className, m_method, "isReserved, and yet, I cannot get reservation object!");
                    return 0;
                }
                return reservationObj.getAccessMask();
            }
            return 0;
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isExclusiveLockOwner() throws VWException {
        String m_method;
        boolean res;
        block11: {
            res = false;
            m_method = "isExclusiveLockOwner:" + this.getId();
            try {
                try {
                    if (this.isReserved()) {
                        Document reservationObj = ((Document)this.m_wcmObject).getReservation();
                        if (reservationObj == null) {
                            logger.warning(m_className, m_method, "isReserved, and yet, I cannot get reservation object!");
                            boolean bl = res;
                            Object var7_7 = null;
                            if (!logger.isFinest()) return bl;
                            logger.finest(m_className, m_method, new Boolean(res).toString());
                            return bl;
                        }
                        int resSecMask = reservationObj.getAccessMask();
                        boolean bl = res = !this.isExternalReference() && (resSecMask & 4) != 0 && (resSecMask & 2) != 0;
                        if (!res) break block11;
                        boolean bl2 = res = reservationObj.getPropertyIntValue("ReservationType") == 32;
                        if (res) {
                            if (logger.isFinest()) {
                                logger.finest(m_className, m_method, "isExclusiveLocked");
                            }
                            String lockOwner = reservationObj.getPropertyStringValue("Creator");
                            if (logger.isFinest()) {
                                logger.finest(m_className, m_method, "LockOwner (" + this.getLabel() + ") is " + lockOwner);
                            }
                            res = this.checkCurrentUser(lockOwner);
                        }
                        break block11;
                    }
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "is not reserved!");
                    }
                }
                catch (Exception e) {
                    logger.throwing(m_className, m_method, e);
                    Object var7_9 = null;
                    if (!logger.isFinest()) return res;
                    logger.finest(m_className, m_method, new Boolean(res).toString());
                    return res;
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (!logger.isFinest()) throw throwable;
                logger.finest(m_className, m_method, new Boolean(res).toString());
                throw throwable;
            }
        }
        Object var7_8 = null;
        if (!logger.isFinest()) return res;
        logger.finest(m_className, m_method, new Boolean(res).toString());
        return res;
    }

    private boolean checkCurrentUser(String user) {
        if (user == null) {
            return false;
        }
        int nUserNames = this.m_currentUser == null ? 0 : this.m_currentUser.length;
        for (int i = 0; i < nUserNames; ++i) {
            if (!user.equalsIgnoreCase(this.m_currentUser[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canAssumeCheckout() {
        String m_method;
        boolean res;
        block11: {
            res = false;
            m_method = "canAssumeCheckout:" + this.getId();
            try {
                try {
                    if (this.isReserved()) {
                        boolean isExclusiveReservation;
                        Document reservationObj = ((Document)this.m_wcmObject).getReservation();
                        if (reservationObj == null) {
                            logger.warning(m_className, m_method, "isReserved, and yet, I cannot get reservation object!");
                            boolean bl = res;
                            Object var8_7 = null;
                            if (!logger.isFinest()) return bl;
                            logger.finest(m_className, m_method, new Boolean(res).toString());
                            return bl;
                        }
                        boolean bSameLockOwner = false;
                        boolean bl = isExclusiveReservation = reservationObj.getPropertyIntValue("ReservationType") == 32;
                        if (isExclusiveReservation) {
                            if (logger.isFinest()) {
                                logger.finest(m_className, m_method, "isExclusiveLocked");
                            }
                            String lockOwner = reservationObj.getPropertyStringValue("Creator");
                            if (logger.isFinest()) {
                                logger.finest(m_className, m_method, "LockOwner (" + this.getLabel() + ") is " + lockOwner);
                            }
                            bSameLockOwner = this.checkCurrentUser(lockOwner);
                        }
                        res = !isExclusiveReservation || bSameLockOwner;
                        break block11;
                    }
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "is not reserved!");
                    }
                }
                catch (Exception e) {
                    logger.throwing(m_className, m_method, e);
                    Object var8_9 = null;
                    if (!logger.isFinest()) return res;
                    logger.finest(m_className, m_method, new Boolean(res).toString());
                    return res;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (!logger.isFinest()) throw throwable;
                logger.finest(m_className, m_method, new Boolean(res).toString());
                throw throwable;
            }
        }
        Object var8_8 = null;
        if (!logger.isFinest()) return res;
        logger.finest(m_className, m_method, new Boolean(res).toString());
        return res;
    }

    public boolean canCheckin() {
        boolean res;
        String m_method = "canCheckin";
        int resSecMask = this.getReservationSecurityMask();
        boolean bl = res = !this.isExternalReference() && this.isReserved() && (resSecMask & 4) != 0 && (resSecMask & 2) != 0 && this.canAssumeCheckout();
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, this.m_currentUser[0] + " can" + (res ? "" : "not") + " check in " + this.getLabel());
        }
        return res;
    }

    public boolean canCancelCheckout() {
        boolean res;
        String m_method = "canCancelCheckout";
        int resSecMask = this.getReservationSecurityMask();
        boolean bl = res = !this.isExternalReference() && this.isReserved() && (resSecMask & 4) != 0 && (resSecMask & 2) != 0 && (resSecMask & 0x10000) != 0 && this.canAssumeCheckout();
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, this.m_currentUser[0] + " can" + (res ? "" : "not") + " cancel checkout " + this.getLabel());
        }
        return res;
    }

    public IVWIDMDocClass getDocClass() throws VWException {
        return this.getClassDescription();
    }

    public boolean isWorkflowDefinition() {
        try {
            return this.getDocClass().isWorkflowDefinition();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isScenarioDefinition() {
        try {
            return this.getDocClass().isScenarioDefinition();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isSimulation() {
        try {
            return this.getDocClass().isSimulation();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setMimeType(int nMimeType) {
        switch (nMimeType) {
            case 0: {
                if (!this.isScenarioDefinition()) break;
                this.m_mimeType = "application/x-filenet-scenariodefinition";
                break;
            }
            case 1: {
                if (!this.isWorkflowDefinition()) break;
                this.m_mimeType = "application/x-filenet-workflowdefinition";
                break;
            }
            case 2: {
                if (!this.isWorkflowDefinition()) break;
                this.m_mimeType = "application/x-filenet-xpdlworkflowdefinition";
            }
        }
    }

    public String getMimeType() {
        String method = "getMimeType:" + this.getId();
        try {
            if (this.m_mimeType == null) {
                this.m_mimeType = this.m_wcmObject.getPropertyStringValue("MimeType");
                if (logger.isFinest()) {
                    logger.finest(m_className, method, "MimeType = " + this.m_mimeType);
                }
            }
        }
        catch (Exception ex) {
            logger.throwing(m_className, method, ex);
        }
        return this.m_mimeType;
    }

    public IVWIDMLink[] getWorkflowLinks(int eventType, int isolatedRegion) throws VWException {
        return null;
    }

    public IVWIDMLink[] getWorkflowLinksForLaunch(int eventType, int isolatedRegion) throws VWException {
        return null;
    }

    public boolean canCreateWorkflowLink(String headWfDefID) throws VWException {
        return false;
    }

    public boolean canCreateWorkflowLink() throws VWException {
        return false;
    }

    public boolean canCreateWorkflowLinkAsWFDefinition() throws VWException {
        return false;
    }

    public IVWIDMLink createWorkflowLink(String linkName, String wfSubject, String wfDefID, String wfTitle, int eventType, String expression) throws VWException {
        return null;
    }

    public String getCanonicalNameWithVer() {
        String m_method = "getCanonicalNameWithVer";
        String id = this.m_versionSeries != null ? this.m_versionSeries.getId() : "";
        String version = this.getId();
        String res = Integer.toString(3) + ":" + this.m_lib.toString() + ":" + id + ":" + version;
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, "returns=" + res);
        }
        return res;
    }

    public String getIdWithVer() {
        return this.getId() + ":" + this.getVersionNumber();
    }

    public String getVWVersion() throws VWException {
        String m_method = "getVWVersion:" + this.getId();
        try {
            String res = this.m_wcmObject.getPropertyStringValue("VWVersion");
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "VWVersion = " + res);
            }
            return res;
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw new VWException("idm.trident.IDMTridentDocument.noVWVersion", "Failed to get VWVersion. {0}.", e.getMessage());
        }
    }

    public void setVWVersion(String vwVersion) throws VWException {
        String m_method = "setVWVersion:" + vwVersion;
        logger.entering(m_className, m_method);
        this.setProp("VWVersion", vwVersion);
        this.save();
        logger.exiting(m_className, m_method);
    }

    public boolean isArchived() {
        return false;
    }

    private boolean isExternalReference() {
        String m_method = "isExternalReference:" + this.getId();
        try {
            if (this.m_mimeType == null) {
                this.m_mimeType = this.getMimeType();
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "MimeType = " + this.m_mimeType);
                }
                this.m_isExternalReference = this.m_mimeType == null ? false : this.m_mimeType.equals("application/x-filenet-external");
            }
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
        }
        return this.m_isExternalReference;
    }

    private boolean isReserved() {
        try {
            boolean res = this.m_wcmObject.getPropertyBooleanValue("IsReserved");
            return res;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isCurrentVersion() {
        try {
            return this.m_wcmObject.getPropertyBooleanValue("IsCurrentVersion");
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isReleasedVersion() {
        try {
            boolean res = this.m_wcmObject.getPropertyIntValue("VersionStatus") == 1;
            return res;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getContents(Document doc, int contentElement) throws VWException {
        byte[] byArray;
        String m_method = "getContents:origDoc=" + this.getId() + ", doc=" + doc.getId() + "(" + Integer.toString(contentElement) + ")";
        TransportInputStream in = null;
        try {
            try {
                int r;
                logger.entering(m_className, m_method);
                try {
                    in = doc.getContentElement(contentElement);
                }
                catch (Exception e) {
                    logger.throwing(m_className, m_method, e);
                    byte[] byArray2 = null;
                    Object var12_9 = null;
                    if (in == null) return byArray2;
                    try {
                        in.close();
                        return byArray2;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    return byArray2;
                }
                long size = in.getContentSize();
                byte[] contents = new byte[(int)size];
                for (long x = 0L; x < size && (r = in.read(contents, (int)x, (int)(size - x))) != -1; x += (long)r) {
                }
                logger.exiting(m_className, m_method, new Long(size));
                byArray = contents;
                Object var12_10 = null;
                if (in == null) return byArray;
            }
            catch (Exception e) {
                throw new VWException("idm.trident.IDMTridentDocument.getContents", "Failed to retrieve document content. {0}", e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            if (in == null) throw throwable;
            try {}
            catch (Exception ex) {
                throw throwable;
            }
            in.close();
            throw throwable;
        }
        try {}
        catch (Exception ex) {
            // empty catch block
            return byArray;
        }
        in.close();
        return byArray;
    }

    public InputStream getContentStream(int contentElement) throws Exception {
        Document doc = (Document)this.m_wcmObject;
        String m_method = "getContentStream:origDoc=" + this.getId() + ", doc=" + doc.getId() + "(" + Integer.toString(contentElement) + ")";
        TransportInputStream in = null;
        logger.entering(m_className, m_method);
        try {
            in = doc.getContentElement(contentElement);
            return in;
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw e;
        }
    }

    public InputStream[] getContentStreams() throws Exception {
        Document doc = (Document)this.m_wcmObject;
        String m_method = "getContentsStreams:" + doc.getId();
        int[] n = doc.getContentElementObjectTypes();
        if (n == null) {
            return null;
        }
        int nItems = n.length;
        InputStream[] res = new InputStream[nItems];
        for (int i = 0; i < nItems; ++i) {
            if (n[i] == 1035) continue;
            TransportInputStream in = null;
            try {
                in = doc.getContentElement(i + 1);
            }
            catch (Exception e) {
                logger.throwing(m_className, m_method, e);
                throw e;
            }
            res[i] = in;
        }
        return res;
    }

    public static Object getProp(Document document, String propName) throws VWException {
        if (document == null) {
            throw new VWException("idm.trident.IDMTridentDocument.noObject", "No object is available.");
        }
        String m_method = "getProp:" + propName + ":" + document.getId();
        try {
            Property prop;
            Object retVal = null;
            Properties props = document.getProperties(new String[]{propName});
            if (props != null && (prop = (Property)props.get(0)) != null) {
                retVal = VWIDMTridentItem.mapGetPropertyValue(prop.getValue(), propName, prop);
            }
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "value=" + (retVal == null ? "NULL" : retVal.toString()));
            }
            return retVal;
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw new VWException("idm.trident.IDMTridentDocument.getProp", "Failed to get property {0}.  {1}", propName, e.getMessage());
        }
    }

    public static Object[] getProps(Document document, String[] propNames) throws VWException {
        if (document == null) {
            throw new VWException("idm.trident.IDMTridentDocument.noObject", "No object is available.");
        }
        String m_method = "getProps:" + Logger.asString(propNames) + ":" + document.getId();
        try {
            Object[] retVals = null;
            Properties props = document.getProperties(propNames);
            if (props != null) {
                int nProps = props.size();
                retVals = new Object[nProps];
                for (int i = 0; i < nProps; ++i) {
                    Property prop = (Property)props.get(i);
                    retVals[i] = prop != null ? VWIDMTridentItem.mapGetPropertyValue(prop.getValue(), propNames[i], prop) : null;
                }
            }
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "value=" + (retVals == null ? "NULL" : Logger.asString(retVals)));
            }
            return retVals;
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw new VWException("idm.trident.IDMTridentDocument.getProps", "Failed to get properties {0}.  {1}", Logger.asString(propNames), e.getMessage());
        }
    }

    public void refresh() throws VWException {
        this.m_versionSeries.refresh();
        this.m_wcmObject = this.m_versionSeries.getCurrentVersion();
        super.refresh();
    }

    public Object[] getProps(String[] propNames) throws VWException {
        return VWIDMTridentDocument.getProps((Document)this.m_wcmObject, propNames);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveContents(byte[] contents, String fileName) throws VWException {
        String m_method = "save:" + this.m_label;
        TransportInputStream in = null;
        try {
            try {
                Document reservationObj = ((Document)this.m_wcmObject).getReservation();
                if (reservationObj == null) {
                    throw new VWException("idm.panagon.IDMDocument.save.noReservation", "The document is not checked out");
                }
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "reservation Id=" + reservationObj.getId());
                }
                in = new TransportInputStream((InputStream)new ByteArrayInputStream(contents));
                in.setContentSize(contents == null ? 0L : (long)contents.length);
                in.setMimeType(this.getMimeType());
                in.setFilename(fileName);
                reservationObj.setContent(in, false, false);
                in.close();
                in = null;
                this.refresh();
            }
            catch (Exception e) {
                logger.throwing(m_className, m_method, e);
                throw new VWException("idm.trident.IDMTridentDocument.saveContents", "Exception: {0}", e.getMessage());
            }
            Object var7_7 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ex) {}
        in.close();
        return;
    }

    public void changeLifeCycleState(int state) throws VWException {
        if (this.m_wcmObject == null) {
            throw new VWException("idm.trident.IDMTridentDocument.noObject", "No object is available.");
        }
        ((Document)this.m_wcmObject).changeLifeCycleState(state);
    }

    public String[] getLifeCycleStates() throws VWException {
        if (this.m_wcmObject == null) {
            throw new VWException("idm.trident.IDMTridentDocument.noObject", "No object is available.");
        }
        return ((Document)this.m_wcmObject).getLifeCycleStates();
    }

    public boolean canDemoteLifeCycleState() throws VWException {
        if (this.m_wcmObject == null) {
            throw new VWException("idm.trident.IDMTridentDocument.noObject", "No object is available.");
        }
        return ((Document)this.m_wcmObject).canDemoteLifeCycleState();
    }

    public void delete() throws VWException {
        if (this.m_wcmObject == null) {
            throw new VWException("idm.trident.IDMTridentDocument.noObject", "No object is available.");
        }
        ((Document)this.m_wcmObject).delete();
    }

    protected void initContents() throws VWException {
        throw new VWException("idm.trident.notImplemented", "Not implemented.");
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public IVWIDMFolder[] getFoldersFiledIn() throws VWException {
        IVWIDMFolder[] res = null;
        String m_method = "getFoldersFiledIn";
        Folders _folders = ((ContainableObject)this.m_wcmObject).getContainers();
        Iterator iter = _folders.iterator();
        int nFolders = _folders.size();
        res = new IVWIDMFolder[nFolders];
        int i = 0;
        while (iter.hasNext()) {
            res[i] = new VWIDMTridentFolder((Folder)iter.next(), this.m_lib);
            if (logger.isFinest()) {
                logger.finest(m_className, "getFoldersFiledIn", "Folder:" + res[i].getId());
            }
            ++i;
        }
        return res;
    }

    public byte[] getContents(int contentElementNo) throws VWException {
        return this.getContents((Document)this.m_wcmObject, contentElementNo);
    }

    /*
     * Loose catch block
     */
    public boolean checkin(byte[][] contents, String[] fileName) throws VWException {
        boolean bl;
        TransportInputStream in;
        String m_method;
        block15: {
            Document reservationObj;
            int nContents;
            block13: {
                boolean bl2;
                block14: {
                    int nFiles;
                    m_method = "checkin multiContents:" + this.getId();
                    nContents = contents == null ? 0 : contents.length;
                    int n = nFiles = fileName == null ? 0 : fileName.length;
                    if (nFiles != nContents || nFiles == 0) {
                        throw new VWException("idm.trident.invalidParameters", "Invalid parameters.");
                    }
                    in = null;
                    logger.entering(m_className, m_method);
                    reservationObj = ((Document)this.m_wcmObject).getReservation();
                    if (reservationObj != null) break block13;
                    logger.warning(m_className, m_method, "No Reservation object?");
                    bl2 = false;
                    Object var12_11 = null;
                    if (in == null) break block14;
                    try {
                        in.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                logger.exiting(m_className, m_method);
                return bl2;
            }
            int contentNo = 0;
            for (int i = 0; i < nContents; ++i) {
                if (contents[i] == null) {
                    throw new VWException("idm.trident.nullContent", "Content is null.");
                }
                VWTimerLog timer = new VWTimerLog("Document.setContent size=" + Long.toString(contents[i].length));
                in = new TransportInputStream((InputStream)new ByteArrayInputStream(contents[i]));
                in.setMimeType(this.getMimeType());
                in.setFilename(fileName[i]);
                in.setContentElement(++contentNo);
                reservationObj.setContent(in, contentNo == nContents, false);
                timer.stop();
                in.close();
                in = null;
            }
            this.refresh();
            bl = true;
            Object var12_12 = null;
            if (in == null) break block15;
            try {
                in.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        logger.exiting(m_className, m_method);
        return bl;
        catch (Exception e) {
            try {
                logger.throwing(m_className, m_method, e);
                throw new VWException("idm.trident.IDMTridentDocument.checkinMultiContents", "{0}", e.getMessage());
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                logger.exiting(m_className, m_method);
                throw throwable;
            }
        }
    }

    public int getNumberOfContentElements() throws VWException {
        Document doc = (Document)this.m_wcmObject;
        int[] n = doc.getContentElementObjectTypes();
        return n == null ? 0 : n.length;
    }

    /*
     * Loose catch block
     */
    public byte[][] getContentElements() throws VWException {
        Document doc = (Document)this.m_wcmObject;
        String m_method = "getContentsElements:" + doc.getId();
        int[] n = doc.getContentElementObjectTypes();
        if (n == null) {
            return null;
        }
        int nItems = n.length;
        byte[][] res = new byte[nItems][];
        for (int i = 0; i < nItems; ++i) {
            int r;
            Exception ex2222;
            Object var16_15;
            TransportInputStream in = null;
            logger.entering(m_className, m_method);
            try {
                in = doc.getContentElement(i + 1);
            }
            catch (Exception e) {
                logger.throwing(m_className, m_method, e);
                byte[][] byArray = null;
                var16_15 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception ex2222) {
                        // empty catch block
                    }
                }
                return byArray;
            }
            long size = in.getContentSize();
            VWTimerLog timer = new VWTimerLog("Document.getContentElements size=" + Long.toString(size));
            byte[] contents = new byte[(int)size];
            for (long x = 0L; x < size && (r = in.read(contents, (int)x, (int)(size - x))) != -1; x += (long)r) {
            }
            timer.stop();
            logger.exiting(m_className, m_method, new Long(size));
            res[i] = contents;
            var16_15 = null;
            if (in == null) continue;
            try {
                in.close();
            }
            catch (Exception ex2222) {}
            continue;
            {
                catch (Exception e) {
                    throw new VWException("idm.trident.IDMTridentDocument.getContents", "Failed to retrieve document content. {0}", e.getMessage());
                }
            }
            catch (Throwable throwable) {
                var16_15 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception ex2222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return res;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getContentElementsToFile() throws VWException {
        doc = (Document)this.m_wcmObject;
        m_method = "getContentsElements:" + doc.getId();
        n = doc.getContentElementObjectTypes();
        if (n == null) {
            return null;
        }
        nItems = n.length;
        res = new String[nItems];
        i = 0;
        while (i < nItems) {
            block33: {
                block32: {
                    block30: {
                        block28: {
                            block29: {
                                if (n[i] == 1035) break block33;
                                in = null;
                                out = null;
                                try {
                                    try {
                                        VWIDMTridentDocument.logger.entering("VWIDMTridentDocument", m_method);
                                        try {
                                            in = doc.getContentElement(i + 1);
                                        }
                                        catch (Exception e) {
                                            VWIDMTridentDocument.logger.throwing("VWIDMTridentDocument", m_method, e);
                                            var10_22 = null;
                                            var21_20 = null;
                                            if (in != null) {
                                                try {
                                                    in.close();
                                                }
                                                catch (Exception ex) {
                                                    // empty catch block
                                                }
                                            }
                                            if (out == null) return var10_22;
                                            try {
                                                out.close();
                                                return var10_22;
                                            }
                                            catch (Exception ex2) {
                                                // empty catch block
                                            }
                                            return var10_22;
                                        }
                                        size = in.getContentSize();
                                        if (size == 0L) {
                                            in.close();
                                            in = null;
                                            var21_20 = null;
                                            if (in == null) break block28;
                                            break block29;
                                        }
                                        prefix = in.getFilename();
                                        if (prefix == null) {
                                            prefix = "DOC";
                                        }
                                        f = File.createTempFile(prefix, ".tmp");
                                        fileName = f.getAbsolutePath();
                                        if (VWIDMTridentDocument.logger.isFinest()) {
                                            VWIDMTridentDocument.logger.finest("VWIDMTridentDocument", m_method, "Writing to " + fileName);
                                        }
                                        out = new BufferedOutputStream(new FileOutputStream(f));
                                        timer = new VWTimerLog("Document.getContentElements size=" + Long.toString(size));
                                        bSize = 10000;
                                        contents = new byte[10000];
                                        for (x = 0L; x < size && (r = in.read(contents, 0, 10000)) != -1; x += (long)r) {
                                            out.write(contents, 0, r);
                                        }
                                        timer.stop();
                                        VWIDMTridentDocument.logger.exiting("VWIDMTridentDocument", m_method, new Long(size));
                                        contents = null;
                                        res[i] = fileName;
                                        break block30;
                                    }
                                    catch (Exception e) {
                                        throw new VWException("idm.trident.IDMTridentDocument.getContents", "Failed to retrieve document content. {0}", e.getMessage());
                                    }
                                }
                                catch (Throwable var20_23) {
                                    block31: {
                                        var21_20 = null;
                                        if (in != null) {
                                            ** try [egrp 3[TRYBLOCK] [8 : 424->432)] { 
lbl72:
                                            // 1 sources

                                            in.close();
                                            break block31;
lbl74:
                                            // 1 sources

                                            catch (Exception ex) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    if (out == null) throw var20_23;
                                    ** try [egrp 4[TRYBLOCK] [9 : 439->447)] { 
lbl79:
                                    // 1 sources

                                    out.close();
                                    throw var20_23;
lbl81:
                                    // 1 sources

                                    catch (Exception ex2) {
                                        // empty catch block
                                    }
                                    throw var20_23;
                                }
                            }
                            ** try [egrp 3[TRYBLOCK] [8 : 424->432)] { 
lbl86:
                            // 1 sources

                            in.close();
                            break block28;
lbl88:
                            // 1 sources

                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                        if (out != null) {
                            try {}
                            catch (Exception ex2) {}
                            out.close();
                        }
                        break block33;
                    }
                    var21_20 = null;
                    if (in != null) {
                        ** try [egrp 3[TRYBLOCK] [8 : 424->432)] { 
lbl101:
                        // 1 sources

                        in.close();
                        break block32;
lbl103:
                        // 1 sources

                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                }
                if (out != null) {
                    try {}
                    catch (Exception ex2) {}
                    out.close();
                }
            }
            ++i;
        }
        return res;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkin(String[] fileNames) throws VWException {
        block16: {
            m_method = "checkin multiContents:" + this.getId();
            if (fileNames == null) {
                return;
            }
            v0 = nFiles = fileNames.length;
            if (nFiles == 0) {
                return;
            }
            in = null;
            try {
                try {
                    VWIDMTridentDocument.logger.entering("VWIDMTridentDocument", m_method);
                    reservationObj = ((Document)this.m_wcmObject).getReservation();
                    if (reservationObj == null) {
                        VWIDMTridentDocument.logger.warning("VWIDMTridentDocument", m_method, "No Reservation object?");
                        throw new VWException("idm.trident.noReservationObject", "Document was not reserved.");
                    }
                    contentNo = 0;
                    for (i = 0; i < nFiles; ++i) {
                        f = new File(fileNames[i]);
                        if (!f.exists() || f.isDirectory()) {
                            VWIDMTridentDocument.logger.warning("VWIDMTridentDocument", m_method, "Skipping " + fileNames[i]);
                            continue;
                        }
                        timer = new VWTimerLog("Document.setContent " + fileNames[i] + " size=" + Long.toString(f.length()));
                        in = new TransportInputStream((InputStream)new BufferedInputStream(new FileInputStream(f)));
                        in.setMimeType(this.getMimeType());
                        in.setFilename(fileNames[i]);
                        in.setContentElement(++contentNo);
                        try {
                            reservationObj.setContent(in, contentNo == nFiles, false);
                        }
                        catch (OutOfMemoryError o) {
                            VWIDMTridentDocument.logger.throwing("VWIDMTridentDocument", m_method, o);
                            throw new VWException("idm.trident.IDMTridentDocument.checkinMultiContentsOutOfMemory", "Out of memory for setting document content.  Use -Xmx###m JVM parameter to increase the available memory for the JVM.");
                        }
                        timer.stop();
                        in.close();
                        in = null;
                    }
                    this.refresh();
                    var12_13 = null;
                    if (in == null) break block16;
                }
                catch (VWException vwex) {
                    throw vwex;
                }
                catch (Exception e) {
                    VWIDMTridentDocument.logger.throwing("VWIDMTridentDocument", m_method, e);
                    throw new VWException("idm.trident.IDMTridentDocument.checkinMultiContents", "{0}", e.getMessage());
                }
            }
            catch (Throwable var11_17) {
                var12_14 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                VWIDMTridentDocument.logger.exiting("VWIDMTridentDocument", m_method);
                throw var11_17;
            }
            ** try [egrp 3[TRYBLOCK] [5 : 403->411)] { 
lbl60:
            // 1 sources

            in.close();
            break block16;
lbl62:
            // 1 sources

            catch (Exception ex) {
                // empty catch block
            }
        }
        VWIDMTridentDocument.logger.exiting("VWIDMTridentDocument", m_method);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkinFromStreams(InputStream[] files, String[] userFileNames, String[] mimeTypes) throws VWException {
        block15: {
            m_method = "checkinFromStreams multiContents:" + this.getId();
            if (files == null) {
                return;
            }
            v0 = nFiles = files.length;
            if (nFiles == 0) {
                return;
            }
            in = null;
            try {
                try {
                    VWIDMTridentDocument.logger.entering("VWIDMTridentDocument", m_method);
                    reservationObj = ((Document)this.m_wcmObject).getReservation();
                    if (reservationObj == null) {
                        VWIDMTridentDocument.logger.warning("VWIDMTridentDocument", m_method, "No Reservation object?");
                        throw new VWException("idm.trident.noReservationObject", "Document was not reserved.");
                    }
                    contentNo = 0;
                    for (i = 0; i < nFiles; ++i) {
                        timer = new VWTimerLog("Document.setContent " + userFileNames[i]);
                        in = new TransportInputStream((InputStream)new BufferedInputStream(files[i]));
                        mimeType = mimeTypes != null && mimeTypes[i] != null ? mimeTypes[i] : this.getMimeType();
                        in.setMimeType(mimeType);
                        in.setFilename(userFileNames[i]);
                        in.setContentElement(++contentNo);
                        try {
                            reservationObj.setContent(in, contentNo == nFiles, false);
                        }
                        catch (OutOfMemoryError o) {
                            VWIDMTridentDocument.logger.throwing("VWIDMTridentDocument", m_method, o);
                            throw new VWException("idm.trident.IDMTridentDocument.checkinMultiContentsOutOfMemory", "Out of memory for setting document content.  Use -Xmx###m JVM parameter to increase the available memory for the JVM.");
                        }
                        timer.stop();
                        in.close();
                        in = null;
                    }
                    this.refresh();
                    var14_15 = null;
                    if (in == null) break block15;
                }
                catch (VWException vwex) {
                    throw vwex;
                }
                catch (Exception e) {
                    VWIDMTridentDocument.logger.throwing("VWIDMTridentDocument", m_method, e);
                    throw new VWException("idm.trident.IDMTridentDocument.checkinMultiContents", "{0}", e.getMessage());
                }
            }
            catch (Throwable var13_19) {
                var14_16 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                VWIDMTridentDocument.logger.exiting("VWIDMTridentDocument", m_method);
                throw var13_19;
            }
            ** try [egrp 3[TRYBLOCK] [5 : 348->356)] { 
lbl57:
            // 1 sources

            in.close();
            break block15;
lbl59:
            // 1 sources

            catch (Exception ex) {
                // empty catch block
            }
        }
        VWIDMTridentDocument.logger.exiting("VWIDMTridentDocument", m_method);
    }

    public static String _get_FILE_DATE() {
        return "$Date:   16 Oct 2006 12:33:44  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   lnguyen  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.83  $";
    }
}

